/*
 * This File is one of the examples from Java Application Development
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package serializationExample;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Can implements Serializable {
    long serialVersionUID = 100; 
    int volume;
    int price;
    String colour;
    String name;
    
        public void saveObject(){
        //Save our datasource
        try (FileOutputStream fos = new FileOutputStream("object");
                ObjectOutputStream out = new ObjectOutputStream(fos);){
            out.writeObject(this);
        } catch (IOException ex) {
            System.out.println(ex);
        }
    }
    
    
    public Object loadObject(){
        try (FileInputStream fis = new FileInputStream("object")){
            ObjectInputStream in = new ObjectInputStream(fis);
            return in.readObject();
        } catch (ClassNotFoundException | IOException ex) {
            System.out.println(ex);
            return null;
        } 
    }
    
    public String toString(){
        return "Name: "+name+" Volume: "+volume+" Price: "+price;
    }
}
